# E0720: function 'let' call may be confused for destructuring; remove parentheses to declare a variable

```config-for-examples
{
    "globals": {
        "let": true,
        "first": true
    }
}
```

In JavaScript, variables can be named `let` and interpreted as a function
call if it is followed by parentheses. This code calls function `let`
instead of destructuring an object:

```javascript
const words = {first: "hello", second: "world"};
let ({first} = words);
```

If you want to declare a variable, remove the parentheses:

```javascript
const words = {first: "hello", second: "world"};
let {first} = words;

```
