# E0427: missing 'break;' or '// fallthrough' comment between statement and 'case'

Switch Cases in javascript fallthrough to the next case if the `break` statement is not added at the end of the case.
Since there is no explicit way of communication whether the fallthrough is intentional or not, it is recommended to use a comment indicating fallthrough.

```javascript
function test (c) {
  switch (c) {
    case 1:
      console.log('case 1');
    default:
      console.log('default');
  }
}
```

To fix this error, place a comment at the end of `case 1` indicating fallthrough

```javascript
function test (c) {
  switch (c) {
    case 1:
      console.log('case 1');
      //fallthrough
    default:
      console.log('default');
  }
}
```
