# E0358: 'declare' should not be written inside a 'declare namespace'

Inside `declare namespace`, declarations (functions, classes, etc.) are
automatically `declare`. It is a syntax error to explicitly write `declare` on
these declarations:

```typescript
declare namespace jQuery {
  declare function get(url);
}
```

To fix this error, remove the `declare` keyword:

```typescript
declare namespace jQuery {
  function get(url);
}
```

This bug is common in `.d.ts` files because many projects use [`skipLibCheck` in
`tsconfig.json`](https://www.typescriptlang.org/tsconfig#skipLibCheck) which
disables TypeScript's checking of `.d.ts` files. We recommend fixing your
`.d.ts` files as described above. If you disagree, please [discuss this with the
quick-lint-js
maintainers](https://github.com/quick-lint/quick-lint-js/issues/1142).
