# E0346: using '==' against a regular expression literal always returns 'false'

In JavaScript, writing `/regularexpression/` creates a new `RegExp` object. so
comparing a regular expression literal using `==`, `===`, `!=`, or `!==` will
always give the same result (`false` or `true`):

```javascript
function isCapitalized(s) {
  return /^[A-Z]/ == s;
}
```

To fix this issue, if you intended to check if a string matches a regular
expression, call the `RegExp#test` method instead of writing `==`:

```javascript
function isCapitalized(s) {
  return /^[A-Z]/.test(s);
}
```

Introduced in quick-lint-js version 2.10.0.
