# E0341: using '===' or '!==' against an array literal does not compare items

Using the strict equality or inequality operator against an array literal will not compare the items in them, e.g. 

```javascript
let x = [1, 2, 3];

// the expression inside the if statement is always 'false'
if (x === [1, 2, 3]) { 
}

// the expression inside the if statement is always 'true'
if (x !== [1, 2, 3]) { 
}
```

There are several ways to fix this warning, for example, we could compare all items manually, or, we could craft a JSON string and compare them

```javascript
let x = [1, 2, 3];

if (JSON.stringify(x) === JSON.stringify([1, 2, 3])) {
}
```


Introduced in quick-lint-js version 2.10.0.
