# E0324: spread tuple elements cannot be optional

```config-for-examples
{
  "globals": {
    "Options": true
  }
}
```

TypeScript tuple types can contain spread elements. By definition, a spread
element is optional. It is a syntax error to write `?` to mark a spread element
as optional:

```typescript
function foo(...args: [...string[]?, Options]) {
  /* ... */
}
```

To fix this error, remove the `?`:

```typescript
function foo(...args: [...string[], Options]) {
  /* ... */
}
```

Introduced in quick-lint-js version 2.10.0.
