# E0318: function overload signature cannot have generator '\*'

In TypeScript, functions can have overload signatures. Overload signatures work
on generator functions, but it is a syntax error for an overload signature
itself to have the generator `*` after the `function` keyword:

```typescript
function* keys<T>(a: T[]): number[];
function* keys(a: object): string[];
function* keys(a: object) {
  if (Array.isArray(a)) {
    for (let k in a) yield +k;
  } else {
    for (let k in a) yield k;
  }
}
```

To fix this error, remove the `*` from the overload signatures, but keep it for
the implementation:

```typescript
function keys<T>(a: T[]): number[];
function keys(a: object): string[];
function* keys(a: object) {
  if (Array.isArray(a)) {
    for (let k in a) yield +k;
  } else {
    for (let k in a) yield k;
  }
}
```

Introduced in quick-lint-js version 2.10.0.
