# E0315: (name) is not the name of a parameter

```config-for-examples
{
  "globals": {
    "user": true,
    "User": true,
    "AdminUser": true
  }
}
```

After a function's parameter list, you can write a TypeScript type predicate
(using `is`) instead of a return type. It is an error for the type predicate to
refer to a variable which is not a parameter:

```typescript
function isError(error: unknown): erorr is Error {
  return error instanceof Error;
}

function isAdminUser(
  user: User | null,
): AdminUser is user {
  return user && user.isAdministrator;
}
```

To fix this error, fix the typo in the parameter name:

```typescript
function isError(error: unknown): error is Error {
  return error instanceof Error;
}
```

Alternatively, flip the parameter name with the type:

```typescript
function isAdminUser(
  user: User | null,
): user is AdminUser {
  return user && user.isAdministrator;
}
```

Introduced in quick-lint-js version 2.10.0.
