# E0308: TypeScript optional parameters are not allowed in JavaScript

```config-for-examples
{
  "globals": {
    "getDefaultOptions": true
  }
}
```

In TypeScript, parameters can be explicitly marked as optional. It is a syntax
error to write `?` to mark a parameter optional in JavaScript:

```javascript
async function download(uri, options?) {
  options ||= getDefaultOptions();
  /* ... */
}
```

In JavaScript, all parameters are optional. To fix this syntax error, remove `?`
from the parameter:

```javascript
async function download(uri, options) {
  options ||= getDefaultOptions();
  /* ... */
}
```

Introduced in quick-lint-js version 2.10.0.
