# E0306: React/JSX is not allowed in vanilla TypeScript code

```config-for-examples
{
  "globals": {
    "React": true,
    "ReactDOM": true
  }
}
```

Vanilla TypeScript does not support JSX syntax (used in React code). It is a
syntax error to create a JSX element or JSX fragment in vanilla TypeScript:

```typescript
ReactDOM.render(
  <h1 className='title'>Hello, world!</h1>,
  document.getElementById('root')
);
```

To fix this error, rename your `.ts` file to have a `.tsx` suffix instead.

Alternatively, use `React.createElement` instead of JSX syntax:

```typescript
ReactDOM.render(
  React.createElement(
    'h1',
    {className: 'title'},
    'Hello, world!',
  ),
  document.getElementById('root'),
);
```

Introduced in quick-lint-js version 2.10.0.
