# E0300: newline is not allowed after 'abstract'

In TypeScript, the `abstract` keyword can be used to mark a class as abstract.
It is an error to put a line break between the `abstract` keyword and the
`class` keyword:

```typescript
export abstract
    class Logger {
  abstract log(message: string);
}
```

To fix this error, put `abstract` and `class` on the same line:

```typescript
export abstract class Logger {
  abstract log(message: string);
}
```

Introduced in quick-lint-js version 2.10.0.
