# E0292: missing semicolon after interface method

TypeScript methods in interfaces must end with either a semicolon (`;`) or a
newline. It is a syntax error to omit the semicolon and write something on the
same line after the method:

```typescript
interface Container {
  getItem(key: string): number | string void;
}
```

To fix this error, write a correct type for the method:

```typescript
interface Container {
  getItem(key: string): number | string | void;
}
```

Introduced in quick-lint-js version 2.10.0.
