# E0284: missing TypeScript type

In TypeScript, you can annotate the type of a variable by writing `:` after its
name in its declaration. It is a syntax error to omit the type after `:`:

```typescript
function api(endpoint: ): Promise<any> {
  // ...
}
```

To fix this error, write a type after the `:`:

```typescript
function api(endpoint: string): Promise<any> {
  // ...
}
```

Alternatively, remove the `:`:

```typescript
function api(endpoint): Promise<any> {
  // ...
}
```

Introduced in quick-lint-js version 2.9.0.
