# E0282: use ':' instead of 'as' to type a function parameter

The `as` operator is not allowed in function parameters. It is a syntax error to
use `as` to annotate a parameter with a type:

```typescript
function reversed<T>(array as T[]): T[] {
  return [...array].reverse();
}
```

To fix this error, write `:` instead of `as`:

```typescript
function reversed<T>(array: T[]): T[] {
  return [...array].reverse();
}
```

Introduced in quick-lint-js version 2.8.0.
