# E0277: newline is not allowed after 'type'

In TypeScript, the `type` keyword must be followed by the type's name.
It is a syntax error to write a newline between `type` and the following
name:

```typescript
export type
  ReallyLongTypeAliasName
  = number;
```

To fix this error, put the type alias' name on the same line as the `type`
keyword:

```typescript
type ReallyLongTypeAliasName
  = number;
```

Introduced in quick-lint-js version 2.8.0.
