# E0275: newline is not allowed after 'interface'

In TypeScript, the `interface` keyword must be followed by the interface's name.
It is a syntax error to write a newline between `interface` and the following
name:

```typescript
interface
    HashMap<Key, Value, Hasher, Comparator> {
  get(k: Key): Value;
}
```

To fix this error, put the interface's name on the same line as the `interface`
keyword:

```typescript
interface HashMap
    <Key, Value, Hasher, Comparator> {
  get(k: Key): Value;
}
```

Introduced in quick-lint-js version 2.8.0.
