# E0261: TypeScript non-null assertions are not allowed in JavaScript

```config-for-examples
{
  "globals": {
    "DoggieTail": true,
    "player": true
  }
}
```

In TypeScript, `!` after a expression is a *non-null assertion*. It is a syntax
error to write a non-null assertion in JavaScript:

```javascript
/** @type {string} favoritePowerRanger */
let favoritePowerRanger;
if (player.hasFavoriteColor) {
  favoritePowerRanger = player.favoriteColor!;
} else {
  favoritePowerRanger = "(unknown)";
}
```

To fix this error, remove the `!`:

```javascript
/** @type {string} favoritePowerRanger */
let favoritePowerRanger;
if (player.hasFavoriteColor) {
  favoritePowerRanger = player.favoriteColor;
} else {
  favoritePowerRanger = "(unknown)";
}
```

Introduced in quick-lint-js version 2.7.0.
