# E0253: use ':' instead of '=' in object literals

JavaScript object literals are key-value pairs. In an expression, it is a syntax
error to write `=` instead of `:` between the key and the value in an object
literal:

```javascript
import fs from 'node:fs/promises';
await fs.mkdir("build/temp", { recursive = true });
```

To fix this error, replace `=` with `:`:

```javascript
import fs from 'node:fs/promises';
await fs.mkdir("build/temp", { recursive: true });
```

Introduced in quick-lint-js version 2.7.0.
