# E0249: computed enum member name must be a simple string

TypeScript enum members can be named using a string literal. The string literal
must not contain parentheses, concatenation, or anything other than a basic
string:

```typescript
enum LogLevel {
  // Our obfuscation scripts get confused by the
  // term "DEBUG" here, so work around it with +.
  ['DE' + 'BUG'] = 'DE' + 'BUG',
}
```

To fix this error, simplify the member name into a string literal:

```typescript
enum LogLevel {
  // Our obfuscation scripts get confused by the
  // term "DEBUG" here, so work around it with
  // a Unicode escape sequence.
  ['DE\u{66}UG'] = 'DE\u{66}UG',
}
```

Introduced in quick-lint-js version 2.7.0.
