# E0238: assignment-asserted fields are not supported in interfaces

In TypeScript, `!` after a field name indicates a *definite assignment
assertion*. These assertions only make sense for classes, not for interfaces. It
is a syntax error to write a definite assignment assertion on an interface
field:

```typescript
interface Point2D {
  x!: number;
  y!: number;
}
```

To fix this error, remove the `!`:

```typescript
interface Point2D {
  x: number;
  y: number;
}
```

Introduced in quick-lint-js version 2.6.0.
