# E0229: missing name for class method

JavaScript class methods must have a name. It is a syntax error to omit the
name:

```javascript
class KittyCat {
  () {
    console.log("meow");
  }
}
new KittyCat().talk();
```

To fix this error, write the method's name before the `(`:

```javascript
class KittyCat {
  talk() {
    console.log("meow");
  }
}
new KittyCat().talk();
```

Alternatively, to really give the method an empty name, write the name as a
string:

```javascript
class KittyCat {
  ""() {
    console.log("meow");
  }
}
new KittyCat()[""]();
```

Introduced in quick-lint-js version 2.6.0.
