# E0226: missing semicolon after index signature

TypeScript index signatures in interfaces must end with either a semicolon
(`;`) or a newline. It is a syntax error to omit the semicolon and write
something on the same line after the index signature:

```typescript
interface APIData {
  [key: string]: number | string void;
}
```

To fix this error, write a correct type for the index signature:

```typescript
interface APIData {
  [key: string]: number | string | void;
}
```

Introduced in quick-lint-js version 2.6.0.
