# E0185: assignment to imported variable; imported variable declared here

It is a `ReferenceError` to assign to variables imported from another module:

```javascript
import { config } from "./default-config.js";
function updateConfig(newConfig) {
  config = newConfig;
}
function dumpConfig() {
  console.log(config);
}
```

To fix this error, create a new variable with `let` and use it instead.

```javascript
import { config as defaultConfig } from "./default-config.js";
let config = defaultConfig;
function updateConfig(newConfig) {
  config = newConfig;
}
function dumpConfig() {
  console.log(config);
}
```

See also: E0003

Introduced in quick-lint-js version 2.0.0.
