# E0161: unclosed object literal; expected '}'

```config-for-examples
{
  "globals": {
    "axios": true,
    "url": true
  }
}
```

An object literal requires a list of properties surrounded by `{` and `}`. It is
a syntax error to start an object literal with `{` but omit the final `}`:

```javascript
let response = await axios.get(url.toString(), {
  validateStatus(_status) {
    return true;
  },
  responseType: "stream"
);
```


To fix this error, write `}` at the end of the object literal:

```javascript
let response = await axios.get(url.toString(), {
  validateStatus(_status) {
    return true;
  },
  responseType: "stream"
});
```

Introduced in quick-lint-js version 0.3.0.
