# E0154: unexpected expression; missing key for object entry

```config-for-examples
{
  "globals": {
    "db": true
  }
}
```

Object literals can contain methods, object spreads, shorthand properties, and
key-value pairs. It is a syntax error to write a complex value (expression)
without a key in an object literal:

```javascript
async function loadUser(id) {
  let row = await db.selectOne('user', {id});
  return {
    ...row,
    password: null,
    row.firstName + " " + row.lastName,
  };
}
```

To fix this error, write a key before the value:

```javascript
async function loadUser(id) {
  let row = await db.selectOne('user', {id});
  return {
    ...row,
    password: null,
    fullName: row.firstName + " " + row.lastName,
  };
}
```

Introduced in quick-lint-js version 0.3.0.
