# E0150: missing body for statement; a lexical declaration is not allowed as the body of statement

```config-for-examples
{
  "globals": {
    "config": true,
    "random": true
  }
}
```

`do`-`while` loops, `if` statements, `for` loops, `while` loops, `with` and labelled
statements require a statement or list of statements for the body. It is a
syntax error to declare a variable with `const` or `let` as the body of such a
statement:

```javascript
let flavors = [];
for (let flavor in config.sweets)

let favoriteFlavor = random.pick(flavors);
```

To fix this error, write the body of the `do`-`while` loop, `if` statements,
`for` loop, `while` loop, or `with` statement:

```javascript
let flavors = [];
for (let flavorName in config.sweets) {
  flavors.push(flavorName);
}

let favoriteFlavor = random.pick(flavors);
```

Introduced in quick-lint-js version 0.2.0.
