# E0115: unexpected 'case' outside switch statement

`switch` statements can contain `case` labels. It is a syntax error to write a
`case` label outside a `switch` statement:

```javascript
function colorToHexCode(color) {
  switch (color) {
  }
    case 'red':   return '#ff0000';
    case 'green': return '#00ff00';
    case 'blue':  return '#0000ff';
}
```

To fix this error, move the `case` label into a `switch` statement:

```javascript
function colorToHexCode(color) {
  switch (color) {
    case 'red':   return '#ff0000';
    case 'green': return '#00ff00';
    case 'blue':  return '#0000ff';
  }
}
```

Introduced in quick-lint-js version 0.2.0.
