# E0094: missing body for 'for' loop

```config-for-examples
{
  "globals": {
    "isDigit": true
  }
}
```

C-style `for` loops, `for`-`in` loops, and `for`-`of` loops require a body,
which must be a statement or `{` `}` surrounding a list of statements. It is a
syntax error to omit the body of a `for` loop:

```javascript
function skipNumber(parser) {
  for (; parser.isDigit(); parser.next())
}
```

To fix this error, write the body of the `for` loop:

```javascript
function skipNumber(parser) {
  for (; parser.isDigit(); parser.next()) {}
}
```

Introduced in quick-lint-js version 0.2.0.
