# E0093: C-style for loop is missing its third component

C-style `for` loops have three components, each separated by `;`: an
initializer, a condition expression, and an update expression. It is a syntax
error to write only two of these three components:

```javascript
for (let i = 0; i < 100) {
  console.log(i % 15 ? i : "FizzBuzz");
}
```

To fix this error, write the missing component:

```javascript
for (let i = 0; i < 100; ++i) {
  console.log(i % 15 ? i : "FizzBuzz");
}
```

Introduced in quick-lint-js version 0.2.0.
