# E0070: commas are not allowed after spread parameter

In a function declaration, an extra `,` can be added to the end of the parameter
list. However, it is a syntax error to include an extra `,` after a spread
parameter:

```javascript
function sum(
  ...numbers,
) {
  return numbers.reduce((x, y) => x+y, 0);
}
```

To fix this error, remove the extra `,`:

```javascript
function sum(
  ...numbers
) {
  return numbers.reduce((x, y) => x+y, 0);
}
```

Introduced in quick-lint-js version 0.2.0.
