# E0065: 'else' has no corresponding 'if'

```config-for-examples
{
  "globals": {
    "end": true,
    "failingTestDescription": true,
    "start": true,
    "testPassed": true
  }
}
```

`if`-`else` statements require an `if` clause. It is a syntax error to have an
`else` without a matching `if` immediately preceeding:

```javascript
if (testPassed)
  console.log("passed!");
  console.log("tests took ${end - start} s");
else {
  console.log("TEST FAILED:");
  console.log(failingTestDescription);
}
```

Note: In the above example, the second `console.log` call is not part of the
`if` statement. Only the first `console.log` call is part of the `if` statement.

To fix this error, make sure your `else` is properly attached to an `if`:

```javascript
if (testPassed) {
  console.log("passed!");
  console.log("tests took ${end - start} s");
} else {
  console.log("TEST FAILED:");
  console.log(failingTestDescription);
}
```

Introduced in quick-lint-js version 0.2.0.
