# E0036: stray comma in let statement

```config-for-examples
{
  "globals": {
    "findCenterPoint": true
  }
}
```

Variables declared by `const`, `let`, and `var` must be separated by a comma
(`,`). It is a syntax error to have multiple commas separating variables:

```javascript
let p = findCenterPoint();
let x = p.x,;
let y = p.y - 1;
```

To fix this error, remove the extra comma:

```javascript
let p = findCenterPoint();
let x = p.x;
let y = p.y - 1;
```

Introduced in quick-lint-js version 0.2.0.
