# E0011: character is not allowed in identifiers

```config-for-examples
{
  "globals": {
  }
}
```

JavaScript allows certain non-ASCII characters in identifiers. Some characters,
including most emoji, are not allowed:

```javascript-ignoring-extra-errors
function 💩AndDie() {
  throw new Error("Not yet implemented");
}

console.log(6 × 9);

let sounds = {
  🐶: "woof",
  🐮: "moo",
  🐱: "meow",
};
```

To fix this error, rename your class, function, or variable:

```javascript
function die() {
  throw new Error("Not yet implemented");
}
```

Alternatively, replace the symbols with ASCII:

```javascript
console.log(6 * 9);
```

Alternatively, write the object key or method name as a string literal:

```javascript
let sounds = {
  "🐶": "woof",
  "🐮": "moo",
  "🐱": "meow",
};
```

Introduced in quick-lint-js version 0.2.0.
