# E0347: duplicated case clause in switch statement

It's common to copy-paste case clauses when writing switch statements, 
but this could lead to duplicated expressions in the switch cases by accident.
For example, in the code below, there's a duplicated case with the expression '*' when '+' was clearly intended.

```javascript
function compute(operator, firstNumber, secondNumber) {
  switch (operator) {
    case '*':
      return firstNumber * secondNumber;
    case '-':
      return firstNumber - secondNumber;
    case '*':
      return firstNumber + secondNumber;
  }
}
```

To fix this warning, we need to replace the expression '*' in the last switch case with the expression '+'

```javascript
function compute(operator, firstNumber, secondNumber) {
  switch (operator) {
    case '*':
      return firstNumber * secondNumber;
    case '-':
      return firstNumber - secondNumber;
    case '+':
      return firstNumber + secondNumber;
  }
}
```
