# E0310: optional parameter cannot have both '?' and initializer; remove '?'

In TypeScript, parameters can be explicitly marked as optional with `?`. It is a
syntax error to write a default initializer for a parameter marked optional with
`?`:

```typescript
async function download(uri, options? = {}) {
  /* ... */
}
```

Parameters with default initializers are always optional. To fix this syntax
error, remove the redundant `?`:

```typescript
async function download(uri, options = {}) {
  /* ... */
}
```

Introduced in quick-lint-js version 2.10.0.
