# E0281: TypeScript 'as' type assertions are not allowed in JavaScript

```config-for-examples
{
  "globals": {
    "container": true
  }
}
```

In TypeScript, the `as` operator is a *type assertion* which reinterprets a
value with a different type at compile time. It is a syntax error to use the
`as` operator in JavaScript code:

```javascript
let avatar =
  container.querySelector(".avatar") as Image;
```

To fix this error, remove `as` and the type:

```javascript
let avatar = container.querySelector(".avatar");
```

Alternatively, rename your file to have a `.ts` or `.tsx` suffix.

Introduced in quick-lint-js version 2.8.0.
