# E0280: 'type' cannot be used twice in export

```config-for-examples
{
  "globals": {
    "ChangeEvent": true,
    "FC": true,
    "createElement": true
  }
}
```

When exporting in TypeScript, `type` can be used to indicate that the symbol
should not be exported at run time. It is a syntax error to mix both `export
type ...` and `export {type ...}`:

```typescript
export type { ChangeEvent,
              createElement,
              type FC,
            };
```

To fix this error, use only the `export {type ...}` syntax:

```typescript
export { type ChangeEvent,
         createElement,
         type FC,
       };
```

Alternatively, use only the `import type ...` syntax, exporting twice if you
also need run time exports:

```typescript
export type { ChangeEvent, FC };
export { createElement };
```

Introduced in quick-lint-js version 2.8.0.
