# E0257: missing ',', ';', or newline between object type entries

In TypeScript, properties in object types are separated by commas, semicolons,
or newlines. It is a syntax error to write two properties without one of those
separators in between:

```typescript
type Status = { ok: boolean error?: string };
```

To fix this error, add a separator between the two properties:

```typescript
type Status = { ok: boolean, error?: string };
```

Introduced in quick-lint-js version 2.7.0.
