# E0252: enum member needs initializer; computed value disables enum autoincrement

```config-for-examples
{
  "globals": {
    "getDefaultLogLevel": true
  }
}
```

In a TypeScript enum, if there is a member with a computed value, the following
member must have an explicit value. It is an error to write an autoincrement
enum member (i.e. one without a value) after a member with a computed value:

```typescript
enum LogLevel {
  DEFAULT = getDefaultLogLevel(),
  DEBUG,
  INFO,
  ERROR,
}
```

To fix this error, write a value for the enum member:

```typescript
enum LogLevel {
  DEFAULT = getDefaultLogLevel(),
  DEBUG = 0,
  INFO,
  ERROR,
}
```

Alternatively, move the member with a computed value after the autoincrement
members:

```typescript
enum LogLevel {
  DEBUG,
  INFO,
  ERROR,
  DEFAULT = getDefaultLogLevel(),
}
```

Introduced in quick-lint-js version 2.7.0.
