# E0230: TypeScript's 'readonly' feature is not allowed in JavaScript code

`readonly` on class properties is a TypeScript feature. It is a syntax error to
use `readonly` in JavaScript code:

```javascript
class Fetcher {
  readonly baseURL;

  constructor(baseURL) {
    this.baseURL = baseURL;
  }
}
```

To fix this error, erase the `readonly`:

```javascript
class Fetcher {
  baseURL;

  constructor(baseURL) {
    this.baseURL = baseURL;
  }
}
```

Alternatively, rename your file to have a `.ts` or `.tsx` suffix

Introduced in quick-lint-js version 2.6.0.
