# E0219: interface properties are always public and cannot be private

TypeScript interfaces describe the properties of objects usable from outside
that object's class. Therefore, all interface properties must be public.
It is an error to declare a private property in an interface:

```typescript
interface Painter {
  paintPixel(pos, color);
  #normalizeColor(color);
  private normalizePos(pos);
}

class CanvasPainter implements Painter {
  paintPixel(pos, color) {
    let c = this.#normalizeColor(color);
    let p = this.normalizePos(pos);
    // ...
  }

  #normalizeColor(color) {
    // ...
  }

  private normalizePos(pos) {
    // ...
  }
}
```

To fix this error, remove the private property from the interface:

```typescript
interface Painter {
  paintPixel(pos, color);
}

class CanvasPainter implements Painter {
  paintPixel(pos, color) {
    let c = this.#normalizeColor(color);
    let p = this.normalizePos(pos);
    // ...
  }

  #normalizeColor(color) {
    // ...
  }

  private normalizePos(pos) {
    // ...
  }
}
```

Introduced in quick-lint-js version 2.6.0.
