# E0177: React/JSX is not allowed in vanilla JavaScript code

```config-for-examples
{
  "globals": {
    "React": true,
    "ReactDOM": true
  }
}
```

Vanilla JavaScript does not support JSX syntax (used in React code). It is a
syntax error to create a JSX element or JSX fragment in vanilla JavaScript:

```javascript
ReactDOM.render(
  <h1>Hello, world!</h1>,
  document.getElementById('root')
);
```

To fix this error, use `React.createElement` instead of JSX syntax:

```javascript
ReactDOM.render(
  React.createElement('h1', null, 'Hello, world!'),
  document.getElementById('root')
);
```

Alternatively, use [`--language=javascript-jsx`][cli-language] instead of
`--language=javascript`.

[cli-language]: ../../cli/#language

Introduced in quick-lint-js version 0.6.0.
