# E0105: missing parameters for arrow function

Arrow functions need a parameter list. It is a syntax error to omit the
parameter list before `=>`, even if the arrow function takes no parameters:

```javascript
setInterval(=> {
  console.log("it is now", new Date());
}, 1000);
```

To fix this error, write an empty parameter list before `=>`:

```javascript
setInterval(() => {
  console.log("it is now", new Date());
}, 1000);
```

Introduced in quick-lint-js version 0.2.0.
