# E0103: missing 'while (condition)' for do-while statement

A `do`-`while` loop has three parts: the `do` keyword, a body (a statement, or a
list of statements surrounded by `{` and `}`), and the `while` part including
the condition. It is a syntax error to write the `do` keyword without the
`while` part:

```javascript
let name;
do {
  name = prompt('What is your name?');
};
while (name === '');
```

To fix this error, make sure there is nothing between the loop's body and the
`while` keyword:

```javascript
let name;
do {
  name = prompt('What is your name?');
}
while (name === '');
```

Introduced in quick-lint-js version 0.2.0.
