# E0012: escaped character is not allowed in identifiers

A function or variable name includes a Unicode escape sequence, and the escape sequence
refers to a character which isn't allowed in a function or variable name:

```javascript
let guitar\u2604 = "\uD83C\uDFB8";
let handc\uffed = true;
```

To fix this error, use the code point of a Unicode character which is allowed,
or remove the extraneous backslash from the name:

```javascript
let guitar\u3604 = "\uD83C\uDFB8";
let handcuffed = true;
```

The initial character in a function or variable name can be any of the
following:

* *ID_Start*
* `$`
* `_`

Characters after the initial character in a function or variable name can be
any of the following:

* *ID_Continue*
* `$`
* ZWJ (U+200D)
* ZWNJ (U+200C)

Introduced in quick-lint-js version 0.2.0.
