// Code generated by tools/generate-lex-keyword.cpp. DO NOT EDIT.
// source: src/quick-lint-js/fe/keyword-lexer.h
// source: src/quick-lint-js/fe/keyword-list.h

// Copyright (C) 2020  Matthew "strager" Glazar
// See end of file for extended copyright information.

#include <cstddef>
#include <cstdint>
#include <quick-lint-js/fe/keyword-lexer.h>
#include <quick-lint-js/fe/lex.h>
#include <quick-lint-js/fe/token.h>
#include <quick-lint-js/port/char8.h>

namespace quick_lint_js {
namespace {
constexpr std::size_t hash_table_size = 256LLU;
constexpr std::size_t hash_table_size_shift = 8LLU;
constexpr std::size_t string_table_size = 454LLU;

constexpr Keyword_Lexer::Seed_Type hash_seed = 2554672LLU;

struct Entry {
  std::uint16_t key_index;  // Index into tables::string_table.
  std::uint8_t key_length;
  Token_Type value;
};

// The two tables are combined into one table to reduce the number of
// instructions dedicated to address computation in the lookup function. (I did
// not measure whether this technique actually improves performance, though.)
struct Tables_Type {
  Entry hash_table[hash_table_size];
  Char8 string_table[string_table_size];
};

// clang-format off
constexpr Tables_Type tables = {
    .hash_table =
        {
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {301, 7, Token_Type::kw_extends},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {253, 10, Token_Type::kw_implements},
            {0, 0, Token_Type::identifier},
            {314, 4, Token_Type::kw_enum},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {406, 5, Token_Type::kw_async},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {156, 8, Token_Type::kw_override},
            {0, 0, Token_Type::identifier},
            {179, 4, Token_Type::kw_null},
            {119, 8, Token_Type::kw_readonly},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {56, 5, Token_Type::kw_throw},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {328, 7, Token_Type::kw_default},
            {63, 2, Token_Type::kw_is},
            {52, 4, Token_Type::kw_true},
            {0, 0, Token_Type::identifier},
            {411, 6, Token_Type::kw_assert},
            {0, 0, Token_Type::identifier},
            {142, 7, Token_Type::kw_private},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {322, 6, Token_Type::kw_delete},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {21, 7, Token_Type::kw_unknown},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {335, 7, Token_Type::kw_declare},
            {0, 0, Token_Type::identifier},
            {112, 7, Token_Type::kw_require},
            {0, 0, Token_Type::identifier},
            {358, 11, Token_Type::kw_constructor},
            {286, 3, Token_Type::kw_for},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {247, 6, Token_Type::kw_import},
            {0, 0, Token_Type::identifier},
            {133, 9, Token_Type::kw_protected},
            {318, 4, Token_Type::kw_else},
            {0, 0, Token_Type::identifier},
            {242, 5, Token_Type::kw_infer},
            {271, 3, Token_Type::kw_get},
            {206, 3, Token_Type::kw_let},
            {94, 3, Token_Type::kw_set},
            {0, 0, Token_Type::identifier},
            {371, 2, Token_Type::kw_as},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {88, 6, Token_Type::kw_static},
            {43, 4, Token_Type::kw_type},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {173, 6, Token_Type::kw_number},
            {77, 5, Token_Type::kw_super},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {5, 4, Token_Type::kw_with},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {18, 3, Token_Type::kw_var},
            {0, 0, Token_Type::identifier},
            {214, 9, Token_Type::kw_intrinsic},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {274, 8, Token_Type::kw_function},
            {421, 8, Token_Type::kw_accessor},
            {0, 0, Token_Type::identifier},
            {418, 3, Token_Type::kw_any},
            {164, 3, Token_Type::kw_out},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {39, 2, Token_Type::kw_in},
            {374, 5, Token_Type::kw_catch},
            {127, 6, Token_Type::kw_public},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {209, 5, Token_Type::kw_keyof},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {61, 4, Token_Type::kw_this},
            {0, 0, Token_Type::identifier},
            {97, 9, Token_Type::kw_satisfies},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {43, 6, Token_Type::kw_typeof},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {358, 5, Token_Type::kw_const},
            {0, 0, Token_Type::identifier},
            {28, 6, Token_Type::kw_unique},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {379, 4, Token_Type::kw_case},
            {296, 5, Token_Type::kw_false},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {47, 2, Token_Type::kw_of},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {383, 5, Token_Type::kw_break},
            {65, 6, Token_Type::kw_symbol},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {34, 9, Token_Type::kw_undefined},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {350, 8, Token_Type::kw_continue},
            {0, 0, Token_Type::identifier},
            {289, 7, Token_Type::kw_finally},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {395, 6, Token_Type::kw_bigint},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {263, 2, Token_Type::kw_if},
            {14, 4, Token_Type::kw_void},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {388, 7, Token_Type::kw_boolean},
            {0, 0, Token_Type::identifier},
            {282, 4, Token_Type::kw_from},
            {0, 0, Token_Type::identifier},
            {0, 5, Token_Type::kw_yield},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {9, 5, Token_Type::kw_while},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {71, 6, Token_Type::kw_switch},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {149, 7, Token_Type::kw_package},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {232, 10, Token_Type::kw_instanceof},
            {0, 0, Token_Type::identifier},
            {183, 3, Token_Type::kw_new},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {429, 8, Token_Type::kw_abstract},
            {200, 6, Token_Type::kw_module},
            {167, 6, Token_Type::kw_object},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {223, 9, Token_Type::kw_interface},
            {122, 2, Token_Type::kw_do},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {369, 5, Token_Type::kw_class},
            {0, 0, Token_Type::identifier},
            {191, 9, Token_Type::kw_namespace},
            {342, 8, Token_Type::kw_debugger},
            {186, 5, Token_Type::kw_never},
            {0, 0, Token_Type::identifier},
            {106, 6, Token_Type::kw_return},
            {265, 6, Token_Type::kw_global},
            {0, 0, Token_Type::identifier},
            {308, 6, Token_Type::kw_export},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {411, 7, Token_Type::kw_asserts},
            {401, 5, Token_Type::kw_await},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {49, 3, Token_Type::kw_try},
            {82, 6, Token_Type::kw_string},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
            {0, 0, Token_Type::identifier},
        },

    .string_table =
        u8"yield"
        u8"with"
        u8"while"
        u8"void"
        u8"var"
        u8"unknown"
        u8"unique"
        u8"undefined"
        u8"typeof"
        u8"try"
        u8"true"
        u8"throw"
        u8"this"
        u8"symbol"
        u8"switch"
        u8"super"
        u8"string"
        u8"static"
        u8"set"
        u8"satisfies"
        u8"return"
        u8"require"
        u8"readonly"
        u8"public"
        u8"protected"
        u8"private"
        u8"package"
        u8"override"
        u8"out"
        u8"object"
        u8"number"
        u8"null"
        u8"new"
        u8"never"
        u8"namespace"
        u8"module"
        u8"let"
        u8"keyof"
        u8"intrinsic"
        u8"interface"
        u8"instanceof"
        u8"infer"
        u8"import"
        u8"implements"
        u8"if"
        u8"global"
        u8"get"
        u8"function"
        u8"from"
        u8"for"
        u8"finally"
        u8"false"
        u8"extends"
        u8"export"
        u8"enum"
        u8"else"
        u8"delete"
        u8"default"
        u8"declare"
        u8"debugger"
        u8"continue"
        u8"constructor"
        u8"class"
        u8"catch"
        u8"case"
        u8"break"
        u8"boolean"
        u8"bigint"
        u8"await"
        u8"async"
        u8"asserts"
        u8"any"
        u8"accessor"
        u8"abstract"
        u8"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",
};
// clang-format on
}

[[gnu::noinline]] Token_Type Lexer::identifier_token_type(
    String8_View identifier) {
  std::size_t identifier_size = identifier.size();

  Keyword_Lexer::Selection_Type selection =
      Keyword_Lexer::select(identifier.data(), identifier_size);
  Keyword_Lexer::Hash_Type index = Keyword_Lexer::mix_and_reduce(
      selection, hash_seed, hash_table_size_shift);

  const Entry& e = tables.hash_table[index];
  const Char8* e_key = &tables.string_table[e.key_index];

  // NOTE(strager): Use a result variable to encourage compilers to generate
  // conditional store instructions. Conditional stores can improve performance
  // significantly because lookups are somewhat unpredictable. (Unfortunately,
  // no compiler reliably generates conditional stores.)
  Token_Type result = e.value;
  if (!Keyword_Lexer::key_strings_equal(e_key, identifier.data(),
                                        identifier_size)) {
    result = Token_Type::identifier;
  }
  if (identifier_size != e.key_length) {
    result = Token_Type::identifier;
  }
  return result;
}
}

// quick-lint-js finds bugs in JavaScript programs.
// Copyright (C) 2020  Matthew "strager" Glazar
//
// This file is part of quick-lint-js.
//
// quick-lint-js is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// quick-lint-js is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with quick-lint-js.  If not, see <https://www.gnu.org/licenses/>.
