# E0719: TypeScript namespace aliases are not allowed in JavaScript

```config-for-examples
{
  "globals": {
    "goog": true
  }
}
```

TypeScript supports aliasing namespaces and namespace members using `import`. It
is a syntax error to write such an alias in JavaScript code:

```javascript
import Chart = goog.Chart;
```

To fix this error, use `const` instead of `import`:

```javascript
const Chart = goog.Chart;
```
```javascript
const { Chart } = goog;
```
