# E0303: 'this' must be the first parameter

TypeScript allows you to explicitly declare the `this` parameter. It is a syntax
error to write another parameter before the `this` parameter:

```typescript
$("form button").each(function (
  index: number,
  this: Element,
) {
  console.log(`disabling button #${index}`);
  $(this).disable();
});
```

To fix this error, move `this` to the start of the parameter list:

```typescript
$("form button").each(function (
  this: Element,
  index: number,
) {
  console.log(`disabling button #${index}`);
  $(this).disable();
});
```

Introduced in quick-lint-js version 2.10.0.
