# E0251: enum value must be a compile-time constant

```config-for-examples
{
  "globals": {
    "getDefaultLogLevel": true
  }
}
```

In TypeScript, normal enums can contain computed values. However, enums declared
with `const enum`, `declare enum`, or `declare const enum` must only contain
compile-time constants. It is an error to write a non-constant value in an enum
which requires constant values:

```typescript
declare enum LogLevel {
  ERROR = 1,
  INFO = 2,
  DEBUG = 3,
  DEFAULT = getDefaultLogLevel(),
}
```

To fix this error, convert the enum member into a variable:

```typescript
declare enum LogLevel {
  ERROR = 1,
  INFO = 2,
  DEBUG = 3,
}
const DEFAULT_LOG_LEVEL: LogLevel
  = getDefaultLogLevel();
```

Alternatively, use a normal enum:

```typescript
enum LogLevel {
  ERROR = 1,
  INFO = 2,
  DEBUG = 3,
  DEFAULT = getDefaultLogLevel(),
}
```

Introduced in quick-lint-js version 2.7.0.
