# E0245: missing body for TypeScript interface

```config-for-examples
{
  "globals": {
    "log": true
  }
}
```

TypeScript interfaces require a body, which must be a list of field and method
signatures surrounded by `{` and `}`. It is a syntax error to omit the body of a
interface:

```typescript
// Tag interfaces
interface Hidden {}
interface Unsafe

interface Logger; {
  log();
}
```

To fix this error, write the body of the class, including `{` and `}`:

```typescript
class Hidden {}
class Unsafe {}
```

Alternatively, remove the stray `;` before `{`:

```typescript
interface Logger {
  log();
}
```

Introduced in quick-lint-js version 2.6.0.
